<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CBackgrounds extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == "backgrounds") {
			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("backgrounds");
			parent::DoEvents();

			$sub = $_GET["sub"];
			
			switch ($sub) {

				case "duplicate.bg":
					return $this->DuplicateBackground();
				break;

				case "duplicate":
					return $this->DuplicateOverlay();
				break;

				case "landing":					
					$sub = "images";
				case "images":
				case "pages":					
				case "titles":					
				case "menu":					
				case "module":					
				case "footer":					
				case "slides":					
				case "overlays":					

					if ($_POST["image_cat_new"] && ($_POST["image_cat_new"] != "new category")) {
						$_POST["image_cat"] = $_POST["image_cat_new"];
					}

					if ($_GET["image_id"] && ($_GET["action"] == "details")) {
						$img = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:backgrounds']} WHERE image_id={$_GET[image_id]}");

						if ($img["image_type"] != "5") {
							urlredirect("index.php?mod=backgrounds&sub=landing&image_id={$_GET[image_id]}&action=edit&returnurl=" . $_GET["returnurl"]);
						}						
					}
										

					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);

					switch ($sub) {
						case "landing":
							$data->functions = array( 
									"onstore" => array(&$this , "StoreBackground" ),
							);					
						break;

						case "overlays":
							$data->functions = array( 
									"onstore" => array(&$this , "StoreOverlays"),
							);					
						break;
					}
					
					
					return $data->DoEvents();
				break;


			}
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreBackground($record) {
		if ($record["image_type"] == "5") {
			urlredirect("index.php?mod=backgrounds&sub=landing&image_id={$_POST[image_id]}&action=details&returnurl=" . $_POST["returnurl"]);
		}
		
	}
	



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreOverlays() {
		$overlays = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:skins_overlays']}");

		if (is_array($overlays)) {

			$tpl = new CTemplateDynamic($this->tpl_path . "admin.overlays.htm");

			foreach ($overlays as $key => $val) {
				$val["image"] = "./overlays/{$val[overlay_id]}.png";

				$overlays_htm .= $tpl->blockReplace("Item" , $val);
			}
			
		}
		

		$minifier = new MatthiasMullie\Minify\CSS();
		$minifier->add($overlays_htm);
		$overlays_htm = $minifier->minify();

		CFile::Save("../upload/skins/overlays.css" , $overlays_htm);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DuplicateOverlay() {

		$item = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:skins_overlays']} WHERE overlay_id={$_GET['overlay_id']}");

		if (!is_array($item)) {
			return "Invalid link !";
		}

		unset($item["overlay_id"]);

		$item["overlay_name"] .= " (Copy)";

		$sid = $this->db->QueryInsert(
			$this->tables['core:skins_overlays'] , 
			$item
		);

		//duplicate image if attached
		if ($item["overlay_image"]) {
			CFile::copy(
				"../upload/skins/overlays/{$_GET[overlay_id]}.png",
				"../upload/skins/overlays/{$sid}.png"
			);
		}
				
		//redirect to details page
		urlredirect(
			"index.php?mod=backgrounds&sub=overlays&overlay_id={$sid}&action=edit&returnurl=" . 
				urlencode("index.php?mod=backgrounds&sub=overlays")
		);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DuplicateBackground() {
		$bg = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:backgrounds']} WHERE image_id={$_GET['image_id']}");
		$oid = $bg["image_id"];

		if (!is_array($bg)) {
			return "Invalid link !";
		}

		unset($bg["image_id"]);

		$bg["image_name"] .= " (Copy)";

		$bid = $this->db->QueryInsert(
			$this->tables['core:backgrounds'] , 
			$bg
		);


		if (file_exists("../upload/backgrounds/{$oid}.mp4")) {
			CFile::copy(
				"../upload/backgrounds/{$oid}.mp4",
				"../upload/backgrounds/{$bid}.mp4"
			);
		}

		if (file_exists("../upload/backgrounds/{$oid}.jpg")) {
			CFile::copy(
				"../upload/backgrounds/{$oid}.jpg",
				"../upload/backgrounds/{$bid}.jpg"
			);
		}

		if (file_exists("../upload/backgrounds/{$oid}.json")) {
			CFile::copy(
				"../upload/backgrounds/{$oid}.json",
				"../upload/backgrounds/{$bid}.json"
			);
		}

		//redirect to details page
		urlredirect(
			"index.php?mod=backgrounds&sub=landing&image_id={$bid}&action=edit&returnurl=" . 
				urlencode("index.php?mod=backgrounds&sub=landing")
		);

	}
	
	
}

?>